<?php
include_once('dataConfig.php');

class DBQuery extends DatabaseAccess
{
	// Get Record Count
	public function getRecordCount($trace = 0, $tblName, $whereClause = '', $selectClause = '')
	{
		$whereStr = '';

		if (@is_array($whereClause))
		{
			$whereStr = '1';
			foreach ($whereClause as $key => $value)
			{
				$whereStr .= " AND $key = '".trim($value)."'";
			}
		}
		elseif ($whereClause != '')
		{
			$whereStr = $whereClause;
		}

		if (!$selectClause) $selectClause = '*';

		$query = "SELECT COUNT($selectClause) AS rcdCount FROM $tblName";

		if ($whereStr) $query .= " WHERE $whereStr";

		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$resultArray = $objDbAccess->selectRecordCount($query);
			unset($objDbAccess);
			return $resultArray['rcdCount'];
		}
	}
// Get Record 
	public function getRecord($trace = 0,$fields,$tblName,$whereClause = '',$offset='',$rowCount='',$orderByCol='',$sortOrder='',$groupBy='')
	{
		$whereStr = '';
		$tblStr = '';

		if (@is_array($fields))
		{
			$fieldStr = implode(",", $fields);
		}
		elseif ($fields != '*')
		{
			$fieldStr = $fields;
		}
		else
		{
			$fieldStr = " * ";
		}
		if (@is_array($tblName))
		{
			$tblStr = implode(",", $tblName);
		}
		else
		{
			$tblStr = $tblName;
		}

		if (@is_array($whereClause))
		{
			$whereStr = '1';
			foreach ($whereClause as $key => $value)
			{
				$whereStr .= " AND $key = '".trim($value)."'";
			}
		}
		elseif ($whereClause != '')
		{
			$whereStr = $whereClause;
		}

		$query = "SELECT $fieldStr ";
		/****************************************************/
		if($tblStr!='') $query .= "FROM $tblStr";   // condition for join query
		
		/****************************************************/

		if ($whereStr) $query .= " WHERE $whereStr";

		if ($groupBy) $query .= " GROUP BY $groupBy";

		if ($orderByCol) $query .= " ORDER BY $orderByCol";

		if ($sortOrder) $query .= " $sortOrder";

		if ($rowCount) $query .= " LIMIT $offset,$rowCount";
		
		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$resultArray = $objDbAccess->selectRecord($query);
			unset($objDbAccess);

			@array_walk_recursive(@$resultArray, 'stripFunction');

			return $resultArray;
			
		}
	}
	
// Get Record Log

       public function getRecordLog($trace = 0,$fields,$tblName,$whereClause = '',$offset='',$rowCount='',$orderByCol='',$sortOrder='',$groupBy='')
	{
		$whereStr = '';
		$tblStr = '';

		if (@is_array($fields))
		{
			$fieldStr = implode(",", $fields);
		}
		elseif ($fields != '*')
		{
			$fieldStr = $fields;
		}
		else
		{
			$fieldStr = " * ";
		}
		if (@is_array($tblName))
		{
			$tblStr = implode(",", $tblName);
		}
		else
		{
			$tblStr = $tblName;
		}

		if (@is_array($whereClause))
		{
			$whereStr = '1';
			foreach ($whereClause as $key => $value)
			{
				$whereStr .= " AND $key = '".trim($value)."'";
			}
		}
		elseif ($whereClause != '')
		{
			$whereStr = $whereClause;
		}

		$query = "SELECT $fieldStr FROM $tblStr";

		if ($whereStr) $query .= " WHERE $whereStr";

		//if ($groupBy) $query .= " GROUP BY $groupBy";

		if ($orderByCol) $query .= " ORDER BY $orderByCol";

		if ($sortOrder) $query .= " $sortOrder";

		if ($rowCount) $query .= " LIMIT $offset,$rowCount";
		
		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$resultArray = $objDbAccess->selectRecord($query);
			unset($objDbAccess);

			@array_walk_recursive(@$resultArray, 'stripFunction');

			return $resultArray;
			
		}
	}
	//***************************************** Normal Join ********************************************//
	
	public function recordJoin($trace = 0,$fields,$tblName,$tblJoin,$whereClause = '',$offset='',$rowCount='',$orderByCol='',$sortOrder='',$groupBy='')
	{
		$whereStr = '';
		$tblStr = '';
		$tblJoinCond ='';

		if (@is_array($fields))
		{
			$fieldStr = implode(",", $fields);
		}
		elseif ($fields != '*')
		{
			$fieldStr = $fields;
		}
		else
		{
			$fieldStr = " * ";
		}
		if (@is_array($tblName))
		{
			$tblStr = implode(",", $tblName);
		}
		else
		{
			$tblStr = $tblName;
		}
		if (@is_array($tblJoin))
		{
			$tblJoinCond = '1';
			foreach ($tblJoin as $key => $value)
			{
				$tblJoinCond .= " AND $key = ".trim($value)."";
			}
		}
		else
		{
			$tblJoinCond = $tblJoin;
		}

		if (@is_array($whereClause))
		{
			
			foreach ($whereClause as $key => $value)
			{
				$whereStr .= " AND $key = '".trim($value)."'";
			}
		}
		elseif ($whereClause != '')
		{
			$whereStr = $whereClause;
		}

		$query = "SELECT $fieldStr FROM $tblStr WHERE $tblJoinCond";

		if ($whereStr) $query .= " $whereStr";

		if ($groupBy) $query .= " GROUP BY $groupBy";

		if ($orderByCol) $query .= " ORDER BY $orderByCol";

		if ($sortOrder) $query .= " $sortOrder";

		if ($rowCount) $query .= " LIMIT $offset,$rowCount";
		
		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$resultArray = $objDbAccess->selectRecord($query);
			unset($objDbAccess);

			@array_walk_recursive(@$resultArray, 'stripFunction');

			return $resultArray;
			
		}
	}
	//******************************************  JOIN *************************************************//
	
	// $profileInfoArr = $db->getJoin(0, array('*'), array('tbl_profiles','tbl_memberships'), array('tbl_profiles.membership_code'=>'tbl_memberships.membership_code',),'JOIN',array('tbl_memberships.membership_name'=>$_GET['membership']), $st, $perPage, 'tbl_profiles.fname', 'ASC');
	
	function getJoin($trace = 0,$fields,$table,$joinCondition='',$joinType='',$whereClause='',$offset='',$rowCount='',$orderByCol='',$sortOrder='',$groupBy='')
	{
		$whereStr = '';	
		$tableStr ='';
		$joinStrCount = '';
		$countWhere='';
		$countTbl ='';
		if (@is_array($fields))
		{
			$fieldStr = implode(",", $fields);
		}
		elseif ($fields != '*')
		{
			$fieldStr = $fields;
		}
		else
		{
			$fieldStr = " * ";
		}
		if (@is_array($joinCondition))
		{
			$joinStrCount = count($joinCondition);
		}
		if (@is_array($whereClause))
		{
			$countWhere = count($whereClause);
		}
		$query = "SELECT $fieldStr FROM ";
		if (@is_array($table))
		{
			$countTbl = count($table);
			if($countTbl>0)
			{	
				$query .= "$table[0] ";
				for($i=1;$i<=$countTbl;$i++)
				{  
					if(@$table[$i]=='') break;
					@$nexttbl = $table[$i];  
					$query .= "$joinType $nexttbl ON";
					if($joinStrCount>0)	
					{
						$joinArr='';
						$joinsArr ='';
						foreach($joinCondition as $values)
						{
							$joinArr = explode('=',$values);
							$tbl1 = explode('.',$joinArr[0]);
							$tbl2 = explode('.',$joinArr[1]);
							if(($tbl1[0]==$table[$i-1] && $tbl2[0]==$table[$i]) && $tbl1[1]==$tbl2[1]) 
							break;
						}  
						
				 $query .= " $values ";	
						
					if(@$countWhere>0)
					{
						foreach($whereClause as $key => $value)
						{	
							$joinArrcond = explode('.',$key); 
							
							if($joinArrcond[0]==$nexttbl ||@$jointbl[0]==$table[$i-1])
							{
								$whereStr .="AND $key = '".trim($value)."'";
								break;
							}
						}
					}
					 $query .= "$whereStr ";
				}
				
			} 
		}
		
	}
	
		if($orderByCol) $query .= " ORDER BY $orderByCol";
		if($sortOrder) $query .= " $sortOrder";
		if($rowCount) $query .= " LIMIT $offset,$rowCount";
		
		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$resultArray = $objDbAccess->selectRecord($query);
			unset($objDbAccess);

			@array_walk_recursive(@$resultArray, 'stripFunction');

			return $resultArray;
			
		}
	}
//******************************************************************************************//	
	public function stripFunction(&$item, $key)
	{
	    $item = trim(stripslashes($item));
	}
// Add Record 
	public function addRecord($trace=0, $setClause, $tblName)
	{
		$setStr = '';

		if (@is_array($setClause))
		{
			$i = 1;
			$fieldCnt = sizeof($setClause);

			foreach ($setClause as $key => $value)
			{
				$setStr .= " $key = '".addslashes(trim($value))."'";
				if($i < $fieldCnt) $setStr .= ", ";
				$i++;
			}
		}
		else
		{
			$setStr = $setClause;
		}

		 $query = "INSERT INTO $tblName SET $setStr";
		
		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$insertId = $objDbAccess->executeQuery($query,'Add');
			unset($objDbAccess);
			return $insertId;
		}
	}
// Update Record 
	public function updateRecord($trace=0,$dataClause,$tblName,$whereClause)
	{
		$whereStr = '';

		$setClause = '';

		if (is_array($dataClause))
		{
			
			$i = 1;
			$fieldCnt = sizeof($dataClause);

			foreach ($dataClause as $key => $value)
			{
				$setClause .= " $key = '".addslashes(trim($value))."'";
				if($i < $fieldCnt) $setClause .= ", ";
				$i++;
			}
		}
		else
		{
			$setClause = $dataClause;
		}

		if (@is_array($whereClause))
		{
			$whereStr = '1';
			foreach ($whereClause as $key => $value)
			{
				$whereStr .= " AND $key = '".trim($value)."'";
			}
		}
		elseif ($whereClause != '')
		{
			$whereStr = $whereClause;
		}

		$query = "UPDATE $tblName SET $setClause";

		if ($whereStr) $query .= " WHERE $whereStr";
		
		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$affectedRows = $objDbAccess->executeQuery($query,'Mod');
			unset($objDbAccess);
			return $affectedRows;
		}
	}
// Delete Record 
	public function deleteRecord($trace=0,$tblName,$whereClause)
	{
		$whereStr = '';

		if (@is_array($whereClause))
		{
			$whereStr = '1';
			foreach ($whereClause as $key => $value)
			{
				$whereStr .= " AND $key = '".trim($value)."'";
			}
		}
		elseif ($whereClause != '')
		{
			$whereStr = $whereClause;
		}

		$query = "UPDATE $tblName SET isDeleted = 'Y'";

		if ($whereStr) $query .= " WHERE $whereStr";

		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$affectedRows = $objDbAccess->executeQuery($query,'Mod');
			unset($objDbAccess);
			return $affectedRows;
		}
	}
// Drop Record 
	public function dropRecord($trace=0,$tblName,$whereClause)
	{
		$whereStr = '';

		if (@is_array($whereClause))
		{
			$whereStr = '1';
			foreach ($whereClause as $key => $value)
			{
				$whereStr .= " AND $key = '".trim($value)."'";
			}
		}
		elseif ($whereClause != '')
		{
			$whereStr = $whereClause;
		}

		$query = "DELETE FROM $tblName";

		if ($whereStr) $query .= " WHERE $whereStr";

		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$affectedRows = $objDbAccess->executeQuery($query,'Del');
			unset($objDbAccess);
			return $affectedRows;
		}
	}

	public function executeSQL($trace=0,$query)
	{
		if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$insertId = $objDbAccess->executeQuery($query,'Add');
			unset($objDbAccess);
			return $insertId;
		}
	}
	
	function prepared_variable($str)
	{
        $str=  trim($str);
        $str=  @mysqli_real_escape_string($str);
        return $str;
    }

   function insert_array($trace=0, $assoc_array, $tablename) 
   {
	   if(is_array($assoc_array))
	   {
			foreach($assoc_array as $key => $value)
			{
				$assoc_array[$key]=  self::prepared_variable($value);
			}
			$index = implode(",", array_keys($assoc_array));
			$values = implode("','", $assoc_array);
			$query = "INSERT INTO $tablename ( $index ) VALUES ( '$values' )";
       }
	   else
		{
			$setStr = $setClause;
		}
	   if ($trace)
		{
			echo "<br>".$query."<br>";
			exit;
		}
		else
		{
			$objDbAccess = new DatabaseAccess();
			$insertId = $objDbAccess->executeQuery($query,'Add');
			unset($objDbAccess);
			return $insertId;
		}
    }
}
$db = new DBQuery();
?>